/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.sax;

import com.aptana.core.logging.IdeLog;
import com.aptana.parsing.ParsingPlugin;
import com.aptana.sax.ISchemaElement;
import com.aptana.sax.InvalidTransitionException;
import com.aptana.sax.Messages;
import com.aptana.sax.Schema;
import com.aptana.sax.SchemaInitializationException;
import com.aptana.sax.ValidatingReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.Plugin;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class SchemaBuilder
extends ValidatingReader {
    private static String OPTIONAL = "optional";
    private static String REQUIRED = "required";
    private static String USAGE_ATTRIBUTE = "usage";
    private static String HAS_TEXT_ATTRIBUTE = "hasText";
    private static String ON_EXIT_ATTRIBUTE = "onExit";
    private static String ON_ENTER_ATTRIBUTE = "onEnter";
    private static String TYPE_ATTRIBUTE = "type";
    private static String NAME_ATTRIBUTE = "name";
    private static String ALLOW_FREEFORM_MARKUP_ATTRIBUTE = "allowFreeformMarkup";
    private static String SCHEMA_1_0_NAMESPACE = "http://www.aptana.com/2005/schema/1.0";
    private static String SCHEMA_1_1_NAMESPACE = "http://www.aptana.com/2007/schema/1.1";
    private Schema _newSchema;
    private Stack<ISchemaElement> _elementStack = new Stack();
    private ISchemaElement _currentElement;
    private String _currentSetId;
    private Map<String, ISchemaElement> _sets = new HashMap<String, ISchemaElement>();
    private Schema _versionSelectorSchema;
    private Schema _schema10;
    private Schema _schema11;

    private SchemaBuilder() {
        this.buildSchemaSchemas();
    }

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        super.startElement(namespaceURI, localName, qualifiedName, attributes);
        switch (Element.fromString(localName)) {
            case SCHEMA: {
                this.startSchemaElement(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case ELEMENT: {
                this.startElementElement(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case ATTRIBUTE: {
                this.startAttributeElement(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case CHILD_ELEMENT: {
                this.startChildElementElement(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case ELEMENT_SET: {
                this.startElementSetElement(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case USE_ELEMENT_SET: {
                this.startUseElementSetElement(namespaceURI, localName, qualifiedName, attributes);
                break;
            }
            case UNDEFINED: {
                IdeLog.logWarning((Plugin)ParsingPlugin.getDefault(), (String)MessageFormat.format("Unable to convert element with name {0} to enum value", localName));
                break;
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
        switch (Element.fromString(localName)) {
            case ELEMENT: {
                this.exitElementElement(namespaceURI, localName, qualifiedName);
                break;
            }
            case ELEMENT_SET: {
                this.exitElementSetElement(namespaceURI, localName, qualifiedName);
                break;
            }
            case UNDEFINED: {
                IdeLog.logWarning((Plugin)ParsingPlugin.getDefault(), (String)MessageFormat.format("Unable to convert element with name {0} to enum value", localName));
                break;
            }
        }
        super.endElement(namespaceURI, localName, qualifiedName);
    }

    private void buildSchemaSchemas() {
        this._schema10 = this.buildSchema10Schema();
        this._schema11 = this.buildSchema11Schema();
        this._versionSelectorSchema = this.buildVersionSelectorSchema();
    }

    private Schema buildVersionSelectorSchema() {
        Schema result = new Schema();
        result.setRootElement(Element.SCHEMA.name);
        return result;
    }

    private Schema buildSchema10Schema() {
        Schema result = new Schema();
        ISchemaElement root = result.createElement(Element.SCHEMA.name);
        result.setRootElement(Element.SCHEMA.name);
        ISchemaElement element = result.createElement(Element.ELEMENT.name);
        root.addTransition(element);
        element.addAttribute(NAME_ATTRIBUTE, REQUIRED);
        element.addAttribute(TYPE_ATTRIBUTE, OPTIONAL);
        element.addAttribute(ON_ENTER_ATTRIBUTE, OPTIONAL);
        element.addAttribute(ON_EXIT_ATTRIBUTE, OPTIONAL);
        element.addAttribute(HAS_TEXT_ATTRIBUTE, OPTIONAL);
        element.addAttribute(ALLOW_FREEFORM_MARKUP_ATTRIBUTE, OPTIONAL);
        ISchemaElement attribute = result.createElement(Element.ATTRIBUTE.name);
        element.addTransition(attribute);
        attribute.addAttribute(NAME_ATTRIBUTE, REQUIRED);
        attribute.addAttribute(USAGE_ATTRIBUTE, OPTIONAL);
        ISchemaElement childElement = result.createElement(Element.CHILD_ELEMENT.name);
        element.addTransition(childElement);
        childElement.addAttribute(NAME_ATTRIBUTE, REQUIRED);
        return result;
    }

    private Schema buildSchema11Schema() {
        Schema result = new Schema();
        ISchemaElement root = result.createElement(Element.SCHEMA.name);
        result.setRootElement(Element.SCHEMA.name);
        ISchemaElement element = result.createElement(Element.ELEMENT.name);
        root.addTransition(element);
        element.addAttribute(NAME_ATTRIBUTE, REQUIRED);
        element.addAttribute(ON_ENTER_ATTRIBUTE, OPTIONAL);
        element.addAttribute(ON_EXIT_ATTRIBUTE, OPTIONAL);
        element.addAttribute(HAS_TEXT_ATTRIBUTE, OPTIONAL);
        element.addTransition(element);
        ISchemaElement attribute = result.createElement(Element.ATTRIBUTE.name);
        element.addTransition(attribute);
        attribute.addAttribute(NAME_ATTRIBUTE, REQUIRED);
        attribute.addAttribute(USAGE_ATTRIBUTE, OPTIONAL);
        ISchemaElement sets = result.createElement(Element.SETS.name);
        root.addTransition(sets);
        ISchemaElement elementSet = result.createElement(Element.ELEMENT_SET.name);
        sets.addTransition(elementSet);
        elementSet.addAttribute("id", REQUIRED);
        elementSet.addTransition(element);
        ISchemaElement useElementSet = result.createElement(Element.USE_ELEMENT_SET.name);
        root.addTransition(useElementSet);
        element.addTransition(useElementSet);
        elementSet.addTransition(useElementSet);
        useElementSet.addAttribute(NAME_ATTRIBUTE, REQUIRED);
        return result;
    }

    public void exitElementElement(String namespaceURI, String localName, String qualifiedName) {
        this._currentElement = this._elementStack.pop();
    }

    public void exitElementSetElement(String namespaceURI, String localName, String qualifiedName) {
        this._sets.put(this._currentSetId, this._currentElement);
        this._currentSetId = null;
        this._currentElement = this._elementStack.pop();
    }

    public static Schema fromXML(String filename) throws SchemaInitializationException {
        FileInputStream fi = null;
        Schema schema = null;
        try {
            try {
                fi = new FileInputStream(filename);
                schema = SchemaBuilder.fromXML(fi);
            }
            catch (FileNotFoundException e) {
                String msg = String.valueOf(Messages.SchemaBuilder_File_Unlocatable) + filename;
                SchemaInitializationException ie = new SchemaInitializationException(msg, e);
                throw ie;
            }
        }
        finally {
            if (fi != null) {
                try {
                    fi.close();
                }
                catch (IOException iOException) {}
            }
        }
        return schema;
    }

    public static Schema fromXML(InputStream in) throws SchemaInitializationException {
        Schema result = new Schema();
        SchemaBuilder builder = new SchemaBuilder();
        builder._schema = builder._versionSelectorSchema;
        builder._schema.reset();
        builder._newSchema = result;
        try {
            builder.read(in);
        }
        catch (ParserConfigurationException e) {
            String msg = Messages.SchemaBuilder_SAX_Parser_Initialization_Error;
            SchemaInitializationException ie = new SchemaInitializationException(msg, e);
            throw ie;
        }
        catch (SAXException e) {
            String msg = Messages.SchemaBuilder_SAX_Parser_Error;
            SchemaInitializationException ie = new SchemaInitializationException(msg, e);
            throw ie;
        }
        catch (IOException e) {
            String msg = Messages.SchemaBuilder_IO_Error;
            SchemaInitializationException ie = new SchemaInitializationException(msg, e);
            throw ie;
        }
        return result;
    }

    public void startAttributeElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) {
        String name = attributes.getValue(NAME_ATTRIBUTE);
        String usage = attributes.getValue(USAGE_ATTRIBUTE);
        this._currentElement.addAttribute(name, usage);
    }

    public void startChildElementElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) {
        String elementName = attributes.getValue(NAME_ATTRIBUTE);
        ISchemaElement element = this._newSchema.createElement(elementName);
        this._currentElement.addTransition(element);
    }

    public void startDocument() {
        super.startDocument();
        this._elementStack.clear();
        this._currentElement = this._newSchema.getRootElement();
    }

    public void startElementElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        String elementName = attributes.getValue(NAME_ATTRIBUTE);
        String elementType = attributes.getValue(TYPE_ATTRIBUTE);
        String hasText = attributes.getValue(HAS_TEXT_ATTRIBUTE);
        String allowFreeformMarkup = attributes.getValue(ALLOW_FREEFORM_MARKUP_ATTRIBUTE);
        ISchemaElement element = this._newSchema.createElement(elementName);
        if (SCHEMA_1_0_NAMESPACE.equals(namespaceURI)) {
            if (elementType != null && elementType.equals("root")) {
                this._currentElement.addTransition(element);
            }
        } else {
            this._currentElement.addTransition(element);
        }
        if (hasText != null && hasText.length() > 0) {
            String lowerHasText = hasText.toLowerCase();
            boolean hasTextValue = lowerHasText.equals("true") || lowerHasText.equals("yes");
            element.setHasText(hasTextValue);
        }
        if (allowFreeformMarkup != null && allowFreeformMarkup.length() > 0) {
            String lowerText = allowFreeformMarkup.toLowerCase();
            boolean allowFreeformMarkupValue = lowerText.equals("true") || lowerText.equals("yes");
            element.setAllowFreeformMarkup(allowFreeformMarkupValue);
        }
        this._elementStack.push(this._currentElement);
        this._currentElement = element;
    }

    public void startElementSetElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) {
        String id;
        ISchemaElement set = this._newSchema.createElement(localName, false);
        this._currentSetId = id = attributes.getValue("id");
        this._elementStack.push(this._currentElement);
        this._currentElement = set;
    }

    public void startSchemaElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        if (SCHEMA_1_0_NAMESPACE.equals(namespaceURI)) {
            this._schema = this._schema10;
        } else if (SCHEMA_1_1_NAMESPACE.equals(namespaceURI)) {
            this._schema = this._schema11;
        } else {
            String message = String.valueOf(Messages.SchemaBuilder_Unknown_Schema_Namespace) + namespaceURI;
            throw new SAXException(message);
        }
        try {
            this._schema.reset();
            this._schema.moveTo(namespaceURI, localName, qualifiedName, attributes);
        }
        catch (IllegalArgumentException e) {
            throw new SAXException(e);
        }
        catch (InvalidTransitionException e) {
            throw new SAXException(e);
        }
        catch (IllegalAccessException e) {
            throw new SAXException(e);
        }
        catch (InvocationTargetException e) {
            throw new SAXException(e);
        }
    }

    public void startUseElementSetElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) {
        String name = attributes.getValue(NAME_ATTRIBUTE);
        String id = name.substring(1);
        this.addSetToElement(id, this._currentElement);
    }

    private void addSetToElement(String id, ISchemaElement element) {
        if (this._sets.containsKey(id)) {
            ISchemaElement set = this._sets.get(id);
            ISchemaElement[] children = set.getTransitionElements();
            if (children != null) {
                ISchemaElement[] iSchemaElementArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    ISchemaElement child = iSchemaElementArray[n2];
                    this._currentElement.addTransition(child);
                    ++n2;
                }
            }
        } else {
            throw new IllegalArgumentException(String.valueOf(Messages.SchemaBuilder_Set_ID_Not_Defined) + id);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Element {
        USE_ELEMENT_SET("use-element-set"),
        ELEMENT_SET("element-set"),
        SETS("sets"),
        CHILD_ELEMENT("child-element"),
        ATTRIBUTE("attribute"),
        ELEMENT("element"),
        SCHEMA("schema"),
        UNDEFINED(null);

        private String name;

        private Element(String name) {
            this.name = name;
        }

        private static Element fromString(String name) {
            if (name != null) {
                Element[] elementArray = Element.values();
                int n = elementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Element b = elementArray[n2];
                    if (name.equals(b.name)) {
                        return b;
                    }
                    ++n2;
                }
            }
            return UNDEFINED;
        }
    }
}

